////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  PDFUtilities.h
//    Utilites helpful for converting types associated wth PDF generation.
//
//  Copyright © 2010-2012 Acclivity Group LLC, all rights reserved.
//
//  Change History (most recent first):
//
//	06/26/11  K.L.S.  Added parameter to ConvertToNSRectAndAdjust.
//	09/16/10  K.L.S.  Created file.
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma once

#import <Cocoa/Cocoa.h>
#include "CrossPlatform/CPCoordinate.h"

class CPRect;
class OBColor;
class OBFontSpec;

CPCoordinate ConvertInchesToPoints(CPCoordinate Inches);
NSColor* ConvertToNSColor(const OBColor& ColorIn);
NSColor* ConvertToNSColor(const OBColor* ColorIn);
NSFont* ConvertToNSFont(const OBFontSpec& FontIn);
NSRect ConvertToNSRect(const CPRect& RectIn);
NSRect ConvertToNSRectAndAdjust(const CPRect& RectIn, float adjustment);
EXTERNAL_API NSDictionary* ConvertToFontAttributes(const OBFontSpec& FontIn, const OBColor& Color);
float FontVerticalSpacing(NSFont* Font);
float FontHeight(NSFont* Font);

NSParagraphStyle* GetParagraphStyle(void);
NSStringDrawingOptions StringDrawingOptions(void);
